<?php

namespace App\Controllers;

use App\Services\AITextGeneratorService;

class AIGeneratorController extends BaseController
{
    protected $aiService;

    public function __construct()
    {
        $this->aiService = new AITextGeneratorService();
    }

    public function generateEducationDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaSekolah = $this->request->getPost('nama_sekolah');
        $jurusan = $this->request->getPost('jurusan') ?? '';
        $jenjang = $this->request->getPost('jenjang') ?? '';
        $tahunMulai = $this->request->getPost('tahun_mulai') ?? '';
        $tahunSelesai = $this->request->getPost('tahun_selesai') ?? '';

        if (empty($namaSekolah)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama sekolah/universitas harus diisi'
            ]);
        }

        $result = $this->aiService->generateEducationDescription($namaSekolah, $jurusan, $jenjang, $tahunMulai, $tahunSelesai);
        return $this->response->setJSON($result);
    }

    public function generateWorkDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaPerusahaan = $this->request->getPost('nama_perusahaan');
        $posisi = $this->request->getPost('posisi') ?? '';
        $tahunMulai = $this->request->getPost('tahun_mulai') ?? '';
        $tahunSelesai = $this->request->getPost('tahun_selesai') ?? '';

        if (empty($namaPerusahaan)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama perusahaan harus diisi'
            ]);
        }

        $result = $this->aiService->generateWorkDescription($namaPerusahaan, $posisi, $tahunMulai, $tahunSelesai);
        return $this->response->setJSON($result);
    }

    public function generateTrainingDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaTraining = $this->request->getPost('nama_training');
        $penyelenggara = $this->request->getPost('penyelenggara') ?? '';
        $durasi = $this->request->getPost('durasi') ?? '';

        if (empty($namaTraining)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama pelatihan harus diisi'
            ]);
        }

        $result = $this->aiService->generateTrainingDescription($namaTraining, $penyelenggara, $durasi);
        return $this->response->setJSON($result);
    }

    public function generateProjectDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaProject = $this->request->getPost('nama_project');
        $teknologi = $this->request->getPost('teknologi') ?? '';
        $tipeProject = $this->request->getPost('tipe_project') ?? '';

        if (empty($namaProject)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama proyek harus diisi'
            ]);
        }

        $result = $this->aiService->generateProjectDescription($namaProject, $teknologi, $tipeProject);
        return $this->response->setJSON($result);
    }

    public function generateOrganizationDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaOrganisasi = $this->request->getPost('nama_organisasi');
        $posisi = $this->request->getPost('posisi') ?? '';
        $bidang = $this->request->getPost('bidang') ?? '';

        if (empty($namaOrganisasi)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama organisasi harus diisi'
            ]);
        }

        $result = $this->aiService->generateOrganizationDescription($namaOrganisasi, $posisi, $bidang);
        return $this->response->setJSON($result);
    }

    public function generateCertificateDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaSertifikat = $this->request->getPost('nama_sertifikat');
        $penerbit = $this->request->getPost('penerbit') ?? '';
        $bidang = $this->request->getPost('bidang') ?? '';

        if (empty($namaSertifikat)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama sertifikat harus diisi'
            ]);
        }

        $result = $this->aiService->generateCertificateDescription($namaSertifikat, $penerbit, $bidang);
        return $this->response->setJSON($result);
    }

    public function generateActivityDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaAktivitas = $this->request->getPost('nama_aktivitas');
        $lokasi = $this->request->getPost('lokasi') ?? '';
        $tipeAktivitas = $this->request->getPost('tipe_aktivitas') ?? '';

        // Debug logging
        log_message('info', 'AI Generate Activity - Data: ' . json_encode([
            'nama_aktivitas' => $namaAktivitas,
            'lokasi' => $lokasi,
            'tipe_aktivitas' => $tipeAktivitas
        ]));

        if (empty($namaAktivitas)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama aktivitas harus diisi'
            ]);
        }

        $result = $this->aiService->generateActivityDescription($namaAktivitas, $lokasi, $tipeAktivitas);
        
        // Debug logging
        log_message('info', 'AI Generate Activity - Result: ' . json_encode($result));
        
        return $this->response->setJSON($result);
    }

    public function generateBiodataProfile()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaLengkap = $this->request->getPost('nama_lengkap');
        $pendidikan = $this->request->getPost('pendidikan') ?? '';
        $keahlian = $this->request->getPost('keahlian') ?? '';
        $pengalaman = $this->request->getPost('pengalaman') ?? '';

        if (empty($namaLengkap)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama lengkap harus diisi'
            ]);
        }

        $result = $this->aiService->generateBiodataProfile($namaLengkap, $pendidikan, $keahlian, $pengalaman);
        return $this->response->setJSON($result);
    }

    public function generateBiodataDescription()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $namaLengkap = $this->request->getPost('nama_lengkap');
        $pendidikan = $this->request->getPost('pendidikan') ?? '';
        $keahlian = $this->request->getPost('keahlian') ?? '';
        $pengalaman = $this->request->getPost('pengalaman') ?? '';
        $minat = $this->request->getPost('minat') ?? '';

        if (empty($namaLengkap)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Nama lengkap harus diisi'
            ]);
        }

        $result = $this->aiService->generateBiodataDescription($namaLengkap, $pendidikan, $keahlian, $pengalaman, $minat);
        return $this->response->setJSON($result);
    }

    public function expandText()
    {
        if (!$this->request->isAJAX()) {
            return $this->response->setJSON(['success' => false, 'message' => 'Invalid request']);
        }

        $existingText = $this->request->getPost('existing_text');
        $context = $this->request->getPost('context') ?? 'general';

        if (empty($existingText) || trim($existingText) === '') {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Teks yang akan dikembangkan harus diisi'
            ]);
        }

        // Debug logging
        log_message('info', 'AI Expand Text - Data: ' . json_encode([
            'existing_text' => $existingText,
            'context' => $context
        ]));

        $result = $this->aiService->expandText($existingText, $context);
        
        // Debug logging
        log_message('info', 'AI Expand Text - Result: ' . json_encode($result));
        
        return $this->response->setJSON($result);
    }
}